# A perl module for BSDP

package BSDP;
use Socket;
	
sub new($;$) {
	my $class=shift;
	my $self=bless {
		'ip'=>shift,
		'dstport'=>undef,
		'type'=>undef,	# Message type; option 1
		'vers'=>undef,	# Version - 1.1
		'prio'=>undef,
		'imagelist'=>[],
		'defid'=>undef,
		'maxlen'=>undef,
		'dstsrvr'=>undef,
		'selimg'=>undef,
		'legacy'=>undef,
		},$class;
	# We might be being created from a received packet.
	$self->parsepacket(shift) if @_;
	return $self;
};

sub parsepacket($) {
	my $self=shift;
	my $raw=shift;
	my @args=unpack('C*',$raw);
	while (@args) {
		my $t=shift(@args);
		my $len=shift(@args);
		my @data=();
		my $numeric=0;
		for (my $i=0;$i<$len;$i++) { $j=shift(@args);$numeric=0x100*$numeric+$j;push(@data,$j);}
		#print "$t [$len] is $numeric ".join(',',@data)."\n";
		if ($t==0) {		# no op
		} elsif ($t==1) {	# Type
			$self->{'type'}=$numeric unless $numeric>3;
		} elsif ($t==2) {	# Version
			$self->{'version'}=$numeric;
		} elsif ($t==3) {	# Client tells /us/ it's using an image
			$self->{'dstsrvr'}=join('.',@data);
		} elsif ($t==4) {	# Server priority; only for outgoing
		} elsif ($t==5) {	# Destination port for reply
			$self->{'dstport'}=$numeric;
		} elsif ($t==6) {	# List path (unused)
		} elsif ($t==7) {	# Default image; only for outgoing
		} elsif ($t==8) { 	# Client requests image
			$self->{'selimg'}=$numeric;
		} elsif ($t==9) {	# List of images; only for outgoing
		} elsif ($t==10){	# Restrict to NetBoot 1.0
			$self->{'legacy'}=1;
		} elsif ($t==11){	# Restrict images; unimplemented
		} elsif ($t==12){	# Maximum length of packed; unimplemented
			$self->{'maxlen'}=$numeric;
		}
	}
	
}

sub type($) {
	my $self=shift;
 	my $old=$self->{'type'};
	$self->{'type'}=shift if @_;
	return $old;
};

sub version($) {
	my $self=shift;
	my $old=$self->{'version'};
	$self->{'version'}=shift if @_;
	return $old;
}
	
sub dstsrvr($) {
	my $self=shift;
	my $old=$self->{'dstsrvr'};
	$self->{'dstsrvr'}=shift if @_;
	return $old;
}

sub dstport($) {
	my $self=shift;
	my $old=$self->{'dstport'};
	$self->{'dstport'}=shift if @_;
	return $old;
}

sub addimage($$) {
	my $self=shift;
	my $image=shift;
	push(@{$self->{'imagelist'}},$image);
};

sub asbytes() {
	my $self=shift;
	# Type of response / version
	my $bs=$self->encode(1,chr($self->{'type'}));
              #.$self->encode(2,chr(1).chr(1))
	      #.$self->encode(3,inet_aton($self->{'ip'}));
	# Priority (if set)
        if (defined($self->{'prio'})) {
		$bs.=$self->encode(4,$self->packtohex(2,$self->{'prio'}));
	}
	# Default ID (if set)
  	if (defined($self->{'defid'})) {
		$bs.=$self->encode(7,$self->packtohex(4,$self->{'defid'}));
	}
   	# Selected image ID 
	if (defined($self->{'selimg'})) {
		$bs.=$self->encode(8,$self->packtohex(4,$self->{'selimg'}));
	}
	# If this was a request for a list of images, send it
	if ($self->{'type'}==1) {
		$bs.=$self->encode(9,$self->imageopts());
	}
	return $bs;
}

sub splittohex($$) {
	my $self=shift;
	my $bytes=shift;
	my $number=shift;
	#print "Splitting $number to $bytes bytes\n";
	$l='00'x$bytes.sprintf('%x',$number);
	#print "L1 $l\n";
	$l=substr($l,-2*$bytes);
	#print "L2 $l\n";
	return ($l =~ m/../g);
}

sub packtohex($$) {
	my $self = shift;
	my $bytes=shift;
	my $number=shift;
	#print "Packing $number to $bytes bytes\n";
	return pack('H*'x$bytes,$self->splittohex($bytes,$number));
}

sub encode($$) {
	my $self=shift;
	my $item=shift;
	my $str=shift;
	return pack('C',$item).pack('C',length($str)).$str;
}

sub prio($) {
	my $self=shift;
	my $old=$self->{'prio'};
	$self->{'prio'}=shift if @_;
	return $old;
}

sub selimg($) {
	my $self=shift;
	my $old=$self->{'selimg'};
	$self->{'selimg'}=shift if @_;
	return $old;
}

sub imageopts() {
	my $self=shift;
	my $result;
	foreach $img (@{$self->{'imagelist'}}) {
		my $id=$img->id();
		my $name=$img->name();
		my $len=length($name);
		next if $len > 0xff;
		$result.=$self->packtohex(4,$id).$self->packtohex(1,$len).$name;
	}
	return $result;
}

sub defid($) {
	my $self=shift;
	my $old=$self->{'defid'};
	$self->{'defid'}=shift if @_;
	return $old;
}

1;
