# A perl module to be a BSDPd

package BSDPD;
use IO::Socket::INET;
use Net::DHCP::Packet;
use Net::DHCP::Constants;
use BSDP::Image;
use BSDP;

use Data::Hexdumper qw(hexdump);

        
sub new($$) {
  my $class=shift;
  my $self=bless {
                'list'=>[],		# Callbacks for list
		'select'=>[],		# Callbacks for select
 		'port'=>undef,		# Port
		'prio'=>0x8000,		# Priority of this server
		'addr'=>undef,		# Address
		'keepgoing'=>1,		# Flag to keep listening
		'insock'=>undef,	# Socket for incoming data
		'myip'=>'127.0.0.1',	# My ip address
		'serv'=>'127.0.0.1',	# IP address of TFTP server
                },$class;
  $self->{'myip'}=shift if @_;
  $self->{'serv'}=shift if @_;
  return $self;
}

sub priority($) {
  my $self=shift;
  $self->{'prio'}=shift;
}

sub bind($$) {
  my $self=shift;
  $self->{'addr'}=shift;
  $self->{'port'}=shift;
}

sub callback($$) {
  my $self=shift;
  my $type=shift;
  my $ref=shift;
  push(@{$self->{$type}},$ref);
}

sub exit($) {
  my $self=shift;
  $self->{'keepgoing'}=0;
}

sub listen() {
  my $self=shift;
  my $insock=IO::Socket::INET->new (
                         LocalPort => $self->{'port'},
                         LocalAddr => $self->{'addr'},
                         Proto     => 'udp'
                       ) || die "Cannot bind to socket: $!\n";
  $self->{'insock'}=$insock;
  while ($self->{'keepgoing'}==1) {
    my $fromaddr=$self->{'insock'}->recv($buf,4096);
    my ($port,$addr)=unpack_sockaddr_in($fromaddr);
    next if length($buf)<290;
    # Some DHCP packets from apple machines are too short to parse! Pad them.
    $buf.=(chr(255)x10) if length($buf)<300;
    my $ipaddr=inet_ntoa($addr);
    $self->parseandrespond($ipaddr,$port,$buf);
  }
  print "Gone deaf\n";
}

sub parseandrespond($$$) {
  my $self=shift;
  my $ipaddr=shift;
  my $port=shift;
  my $packet=shift;
  my $dhcpreq;
  eval {
   $dhcpreq=new Net::DHCP::Packet($packet);
   1;
  } ;
  # Only proceed if we could parse the packet
  return if not defined($dhcpreq);
  # Only proceed if the packet is DHCPINFORM 
  return if $dhcpreq->getOptionValue(DHO_DHCP_MESSAGE_TYPE()) != DHCPINFORM();
  # and from AAPLBSDPC 
  return if $dhcpreq->getOptionValue(DHO_VENDOR_CLASS_IDENTIFIER()) !~ /AAPLBSDPC/;
  my $bsdpopts=$dhcpreq->getOptionRaw(DHO_VENDOR_ENCAPSULATED_OPTIONS);
  my $inpkt=undef;
  eval {
   $inpkt=new BSDP($myip,$bsdpopts);
   1;
  };
  # Only proceed if we could parse the BSDP packet;
  return if not defined($inpkt);
  my $outpkt=new BSDP($self->{'myip'});
  # Take some default settings from the client
  $outpkt->type($inpkt->type());
  $outpkt->version($inpkt->version());
  my $resp=new Net::DHCP::Packet(
				Comment=>0,
                                Op => BOOTREPLY(),
                                Hops => $dhcpreq->hops(),
                                Xid => $dhcpreq->xid(),
                                Flags => $dhcpreq->flags(),
                                Ciaddr => $dhcpreq->ciaddr(),
                                Siaddr => $self->{'myip'},
                                Giaddr => $dhcpreq->giaddr(),
                                Chaddr => $dhcpreq->chaddr(),
                                DHO_DHCP_SERVER_IDENTIFIER() => $self->{'myip'},
                                DHO_DHCP_MESSAGE_TYPE() => DHCPACK(),
                                Yiaddr => $dhcpreq->getOptionValue(DHO_DHCP_REQUESTED_ADDRESS()),
                                );
  $resp->addOptionValue(DHO_VENDOR_CLASS_IDENTIFIER(),'AAPLBSDPC');
  if ($inpkt->type()==1) {
    print "Recieved DHCPINFORM[LIST] packet from $ipaddr (".sprintf('0x%x',$dhcpreq->xid())."\n";
    $outpkt->prio($self->{'prio'});
    $resp->yiaddr($dhcpreq->getOptionValue(DHO_DHCP_REQUESTED_ADDRESS()));
    for my $cb (@{$self->{'list'}}) {
      $cb->(substr($dhcpreq->chaddr(),0,2*$dhcpreq->hlen()),$ipaddr,$inpkt,$outpkt,$resp);
    }
    my $bytes=$outpkt->asbytes();
    $resp->addOptionRaw(DHO_VENDOR_ENCAPSULATED_OPTIONS(),$bytes);
  } elsif ($inpkt->type()==2) {
    print "Received DHCPINFORM[SELECT] from $ipaddr\n";
    # Ensure it is mine!
    #print "Intended recipient is ".$inpkt->dstsrvr()."\n";
    return unless $inpkt->dstsrvr() eq $self->{'myip'};
    # Build an outgoing DHCPACK[SELECT] response
    $resp->yiaddr('0.0.0.0');
    $resp->sname($self->{'serv'});
    $resp->ciaddr($ipaddr);
    for my $cb (@{$self->{'select'}}) {
      $cb->(substr($dhcpreq->chaddr(),0,2*$dhcpreq->hlen()),$ipaddr,$inpkt,$outpkt,$resp);
    }
    my $bytes=$outpkt->asbytes();
    $resp->addOptionRaw(DHO_VENDOR_ENCAPSULATED_OPTIONS(),$bytes);
  }
  print "Sending DHCPACK[".($inpkt->type()==1?'LIST':'SELECT')."] to $ipaddr:".($inpkt->dstport()?$inpkt->dstport():$port)."\n";
  #print Dumper($outpkt);
  my $rsock=IO::Socket::INET->new (
              LocalPort=>68, 
              PeerPort=>($inpkt->dstport()?$inpkt->dstport():$port), 
              PeerAddr=>$ipaddr,
              Proto=>'udp'
            ) || die ("No sock: $!\n");
  #print hexdump($resp->serialize());
  $rsock->send($resp->serialize());
}
1;

