#!/usr/bin/perl
# A BSDP daemon: just listens on broadcast for now
use BSDPD;
use Data::Dumper;
use DBI;
use threads;

# The IP address of this BSDP server
my $myip='127.0.0.1';
# The IP address of a TFTP server
my $serv='127.0.0.1';
# The broadcast address on which to listen
my $bcast='255.255.255.255';

# Create list of images
# This image is only offered if 'dsk_nuke' is set
my $bi_nuke=new BSDP::Image('Erase Mac');
$bi_nuke->setinstall();
$bi_nuke->index(136);
$bi_nuke->os(1);    # osx (0-os9,2-osxs,3-hwdiag)

# This image is only offered if 'dsk_nuke' is /not/ set
my $bi_inst=new BSDP::Image('Reinstall Mac');
$bi_inst->setinstall();
$bi_inst->index(137);
$bi_inst->os(1);

my $bi_boot=new BSDP::Image('Netboot Mac');
$bi_boot->setboot();
$bi_boot->index(138);
$bi_boot->os(1);

my $bi_diag=new BSDP::Image('Test Mac Hardware');
$bi_diag->setboot();
$bi_diag->index(139);
$bi_diag->os(3);

# A hash of the files for these various images
my $bootimageids={};
$bootimageids->{$bi_nuke->id()}='/osx/netinstall/boot.efi';
$bootimageids->{$bi_inst->id()}='/osx/netinstall/boot.efi';
$bootimageids->{$bi_boot->id()}='/osx/netboot/boot.efi';
$bootimageids->{$bi_diag->id()}='/osx/aht';

# Launch a couple of threads
my $bcast = threads->create('listenbroadcast');
my $ucast = threads->create('listenunicast');
$bcast->join();
$ucast->join();
exit;

sub listenunicast() {
 $dbh = DBI->connect("dbi:Pg:host=$PSQL_HOST;dbname=$PSQL_DB",$PSQL_USER, $PSQL_PASSWORD);
 $sth=$dbh->prepare($sql);
 # Create a BSDPD listening on the broadcast address
 my $bsdpd=new BSDPD($myip,$serv);
 $bsdpd->bind($myip,67);
 $bsdpd->callback('list',\&handlelist);
 $bsdpd->callback('select',\&handleselect);
 $|=1;
 $SIG{'INT'}='Inthandler';
 $bsdpd->listen(); # Loops forever. Or until bad things happen
}


sub listenbroadcast() {
 # Create a BSDPD listening on the broadcast address
 $dbh = DBI->connect("dbi:Pg:host=$PSQL_HOST;dbname=$PSQL_DB",$PSQL_USER, $PSQL_PASSWORD);
 $sth=$dbh->prepare($sql);
 my $bsdpd=new BSDPD($myip,$serv);
 $bsdpd->bind($bcast,67);
 $bsdpd->callback('list',\&handlelist);
 $bsdpd->callback('select',\&handleselect);
 $|=1;
 $SIG{'INT'}='Inthandler';
 $bsdpd->listen(); # Loops forever. Or until bad things happen
}

sub Inthandler() {
 print "Handling INT\n";
 $bsdpd->exit() if $bsdpd;
 $SIG{'INT'}='DEFAULT';
}

# A callback routine ($mac, $ip, $inpkt, $outpkt, $resp)
sub handlelist($$$$$) {
  my $mac=shift;
  my $ip=shift;
  my $inpkt=shift;
  my $outpkt=shift;
  my $resp=shift;

  # Here we put together a list of images to choose from 
  $outpkt->addimage($bi_nuke);
  $outpkt->addimage($bi_inst);
  $outpkt->addimage($bi_boot);
  $outpkt->addimage($bi_diag);
  
  # And set the default to be 'Diagnostics'
  $outpkt->defid($bi_diag->id());
}

# A callback routine for handling the 'select' packet ($mac, $ip, $inpkt, $outpkt, $resp)
sub handleselect($$$$$) {
  my $mac=shift;
  my $ip=shift;
  my $inpkt=shift;
  my $outpkt=shift;
  my $resp=shift;

  # Here we return the filename which the client has chosen to boot.
  my $selimg=$inpkt->selimg();
  my $file=$bootimageids->{$selimg};
  $resp->file($file);
  $outpkt->selimg($selimg);
}

